% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_prepare_plot.R
\name{LDA_prepare_plot}
\alias{LDA_prepare_plot}
\title{LDA_prepare_plot}
\usage{
LDA_prepare_plot(LDA_tab, uncertainty = "act")
}
\arguments{
\item{LDA_tab}{LDA data.frame
("cells", "wells", "positive", "group", "replicate")}

\item{uncertainty}{method for approximation of uncertainties of survival
fractions (SF): activity based ("act") or by error propagation ("ep")}
}
\value{
none
}
\description{
analyze limiting dilution assay (LDA) data and collect
     information for plotting.
}
\examples{
x <- data.frame("cells" = rep(c(10,50,100,250),times = 4),
                "wells" = rep(25,16),
                "positive" = c(2,5,10,20,1,2,6,11,3,4,8,22,1,1,7,12),
                "group" = rep(c(rep("A",4),rep("B",4)),times = 2),
                "replicate" = c(rep(1,8),rep(2,8)))
LDA_prepare_plot(x)
# data(LDAdata)
# Z1 <- subset.data.frame(LDAdata,subset = name == unique(LDAdata$name)[1])
# LDA_prepare_plot(Z1[,c("S-value","# Tested","# Clonal growth","Group",
#                      "replicate")])
}
