% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_survival_single.R
\name{LDA_survival_single}
\alias{LDA_survival_single}
\title{LDA_survival_single}
\usage{
LDA_survival_single(act.0, act.x)
}
\arguments{
\item{act.0}{reference activity}

\item{act.x}{activity after treatment}
}
\value{
list object with survival fraction, estimated confidence intervals
  (by error propagation through first order Taylor series approximation and
  by combination of 84%-uncertainty-intervals of activity estimates)
}
\description{
calculate clonogenic survival fraction from LDA_activity
  objects.
}
\examples{
x.a <- data.frame("cells" = c(10,50,100,250),
                "wells" = rep(25,4),
                "positive" = c(2,5,10,20))
x.b <- data.frame("cells" = c(10,50,100,250),
                "wells" = rep(25,4),
                "positive" = c(1,2,6,11))
act.a <- LDA_activity_single(x.a)
act.b <- LDA_activity_single(x.b)
sf <- LDA_survival_single(act.0 = act.a,act.x = act.b)
data(LDAdata)
cell.line <- unique(LDAdata$name)[1]
x <- subset.data.frame(LDAdata, subset = (name==cell.line) & (Group < 2))
act <- LDA_activity(x[,c(4:6,3)])
sf <- LDA_survival_single(act.0 = act[[1]],act.x = act[[2]])
}
