% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{longitudinal_folds}
\alias{longitudinal_folds}
\title{Longitudinal folds}
\usage{
longitudinal_folds(cv_iter = 1, cv_folds = 10, id, formula = NULL,
  data = NULL, data_needed = NULL, print = TRUE)
}
\arguments{
\item{cv_iter}{Number of cross-validation iterations (Default = 1).}

\item{cv_folds}{Number of cross-validation folds (Default = 10).}

\item{id}{Factor vector containing the id number of each observation.}

\item{formula}{Optional Model formula. If data and formula are provided, only the non-missing observations will be used when creating the folds (Put "formula" here if you have missing data).}

\item{data}{Optional data.frame used for the formula. If data and formula are provided, only the non-missing observations will be used when creating the folds (Put "data" here if you have missing data).}

\item{data_needed}{Optional data.frame with variables that have to be included (Put "cbind(genes,env)"" or "latent_var" here if you have missing data).}

\item{print}{If FALSE, nothing except warnings will be printed. (Default = TRUE).}
}
\value{
Returns a list of vectors containing the fold number for each observation
}
\description{
Function to create folds adequately for longitudinal datasets by forcing every observation with the same id to be in the same fold. Can be used with LEGIT_cv to make sure that the cross-validation folds are appropriate when using longitudinal data.
}
\examples{
train = example_2way(500, 1, seed=777)
# Assuming it's longitudinal with 4 timepoints, even though it's not
id = factor(rep(1:125,each=4))
fit_cv = LEGIT_cv(train$data, train$G, train$E, y ~ G*E, folds=longitudinal_folds(1,10, id))
}
