% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AvgAbsCor.R
\name{AvgAbsCor}
\alias{AvgAbsCor}
\title{Calculate the Average Absolute Correlation}
\usage{
AvgAbsCor(X)
}
\arguments{
\item{X}{A Matrix.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating average absolute correlation.
}
\description{
\code{AvgAbsCor} returns the average absolute correlation of an LHD
}
\details{
\itemize{
\item \code{X} stands for the design matrix.
\item The average absolute correlation formula is given by the Note Section below.
}
}
\note{
\code{average absolute correlation = \\frac{2 \\sum_{i=1}^{k-1} \\sum_{j=i+1}^{k}|q_{ij}|}{k(k-1)}}
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the average absolute correlation of toy
AvgAbsCor(X=toy)

}
\references{
Georgiou, S. D. (2009) Orthogonal Latin hypercube designs from generalized orthogonal designs. \emph{Journal of Statistical Planning and Inference}, \strong{139}, 1530-1540.
}
