% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zagent.R
\name{Agent}
\alias{Agent}
\title{Agent Class for LLM Interactions}
\description{
An R6 class representing an agent that interacts with language models.

*At agent-level we do not automate summarization.* The `maybe_summarize_memory()`
 function can be called manually if the user wishes to compress the agent's memory.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Unique ID for this Agent.}

\item{\code{context_length}}{Maximum number of conversation turns stored in memory.}

\item{\code{model_config}}{The \code{llm_config} specifying which LLM to call.}

\item{\code{memory}}{A list of speaker/text pairs that the agent has memorized.}

\item{\code{persona}}{Named list for additional agent-specific details (e.g., role, style).}

\item{\code{enable_summarization}}{Logical. If TRUE, user *may* call `maybe_summarize_memory()`.}

\item{\code{token_threshold}}{Numeric. If manually triggered, we can compare total_tokens.}

\item{\code{total_tokens}}{Numeric. Estimated total tokens in memory.}

\item{\code{summarization_density}}{Character. "low", "medium", or "high".}

\item{\code{summarization_prompt}}{Character. Optional custom prompt for summarization.}

\item{\code{summarizer_config}}{Optional \code{llm_config} for summarizing the agent's memory.}

\item{\code{auto_inject_conversation}}{Logical. If TRUE, automatically prepend conversation memory if missing.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Agent-new}{\code{Agent$new()}}
\item \href{#method-Agent-add_memory}{\code{Agent$add_memory()}}
\item \href{#method-Agent-maybe_summarize_memory}{\code{Agent$maybe_summarize_memory()}}
\item \href{#method-Agent-generate_prompt}{\code{Agent$generate_prompt()}}
\item \href{#method-Agent-call_llm_agent}{\code{Agent$call_llm_agent()}}
\item \href{#method-Agent-generate}{\code{Agent$generate()}}
\item \href{#method-Agent-think}{\code{Agent$think()}}
\item \href{#method-Agent-respond}{\code{Agent$respond()}}
\item \href{#method-Agent-reset_memory}{\code{Agent$reset_memory()}}
\item \href{#method-Agent-clone}{\code{Agent$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-new"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-new}{}}}
\subsection{Method \code{new()}}{
Create a new Agent instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$new(
  id,
  context_length = 5,
  persona = NULL,
  model_config,
  enable_summarization = TRUE,
  token_threshold = 1000,
  summarization_density = "medium",
  summarization_prompt = NULL,
  summarizer_config = NULL,
  auto_inject_conversation = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character. The agent's unique identifier.}

\item{\code{context_length}}{Numeric. The maximum number of messages stored (default = 5).}

\item{\code{persona}}{A named list of persona details.}

\item{\code{model_config}}{An \code{llm_config} object specifying LLM settings.}

\item{\code{enable_summarization}}{Logical. If TRUE, you can manually call summarization.}

\item{\code{token_threshold}}{Numeric. If you're calling summarization, use this threshold if desired.}

\item{\code{summarization_density}}{Character. "low", "medium", "high" for summary detail.}

\item{\code{summarization_prompt}}{Character. Optional custom prompt for summarization.}

\item{\code{summarizer_config}}{Optional \code{llm_config} for summarization calls.}

\item{\code{auto_inject_conversation}}{Logical. If TRUE, auto-append conversation memory to prompt if missing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Agent} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-add_memory"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-add_memory}{}}}
\subsection{Method \code{add_memory()}}{
Add a new message to the agent's memory.
We do NOT automatically call summarization here.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$add_memory(speaker, text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{speaker}}{Character. The speaker name or ID.}

\item{\code{text}}{Character. The message content.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-maybe_summarize_memory"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-maybe_summarize_memory}{}}}
\subsection{Method \code{maybe_summarize_memory()}}{
Manually compress the agent's memory if desired.
Summarizes all memory into a single "summary" message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$maybe_summarize_memory()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-generate_prompt"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-generate_prompt}{}}}
\subsection{Method \code{generate_prompt()}}{
Internal helper to prepare final prompt by substituting placeholders.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$generate_prompt(template, replacements = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template}}{Character. The prompt template.}

\item{\code{replacements}}{A named list of placeholder values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character. The prompt with placeholders replaced.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-call_llm_agent"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-call_llm_agent}{}}}
\subsection{Method \code{call_llm_agent()}}{
Low-level call to the LLM (via \code{call_llm()}) with a final prompt.
If persona is defined, a system message is prepended to help set the role.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$call_llm_agent(prompt, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{Character. The final prompt text.}

\item{\code{verbose}}{Logical. If TRUE, prints debug info. Default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with:
  * text
  * tokens_sent
  * tokens_received
  * full_response (raw list)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-generate"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-generate}{}}}
\subsection{Method \code{generate()}}{
Generate a response from the LLM using a prompt template and optional replacements.
Substitutes placeholders, calls the LLM, saves output to memory, returns the response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$generate(prompt_template, replacements = list(), verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt_template}}{Character. The prompt template.}

\item{\code{replacements}}{A named list of placeholder values.}

\item{\code{verbose}}{Logical. If TRUE, prints extra info. Default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with fields \code{text}, \code{tokens_sent}, \code{tokens_received}, \code{full_response}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-think"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-think}{}}}
\subsection{Method \code{think()}}{
The agent "thinks" about a topic, possibly using the entire memory in the prompt.
If auto_inject_conversation is TRUE and the template lacks \{\{conversation\}\}, we prepend the memory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$think(topic, prompt_template, replacements = list(), verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topic}}{Character. Label for the thought.}

\item{\code{prompt_template}}{Character. The prompt template.}

\item{\code{replacements}}{Named list for additional placeholders.}

\item{\code{verbose}}{Logical. If TRUE, prints info.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-respond"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-respond}{}}}
\subsection{Method \code{respond()}}{
The agent produces a public "response" about a topic.
If auto_inject_conversation is TRUE and the template lacks \{\{conversation\}\}, we prepend the memory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$respond(topic, prompt_template, replacements = list(), verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topic}}{Character. A short label for the question/issue.}

\item{\code{prompt_template}}{Character. The prompt template.}

\item{\code{replacements}}{Named list of placeholder substitutions.}

\item{\code{verbose}}{Logical. If TRUE, prints extra info.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with \code{text}, \code{tokens_sent}, \code{tokens_received}, \code{full_response}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-reset_memory"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-reset_memory}{}}}
\subsection{Method \code{reset_memory()}}{
Reset the agent's memory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$reset_memory()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
