% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hlGOF.test.r
\name{hlGOF.test}
\alias{hlGOF.test}
\title{Display Hosmer-Lemeshow statistic and table of probabilities following logistic
regression using glm with binomial family.}
\format{\describe{
\item{x}{
The function has three arguments: observed term, predicted values, # groups}
}}
\usage{
hlGOF.test(observed, predicted, breaks = 15)
}
\arguments{
\item{observed}{response variable}

\item{predicted}{predicted statistic}

\item{breaks}{breaks or groups}
}
\value{
numeric
}
\description{
Provides a Hosmer-Lemeshow statistic and table following logistic regression.
}
\details{
hlGOF.test is a post-estimation function for logistic regression, following the use
of glm(). Usage displays a table of observed vs predicted groups and an overall
H-L goodness-of-fit statistic. The test is originally from Hilbe (2009).
}
\note{
hlGOF.test must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user. My thanks to Prof. Robert LaBudde for the initial
version of this function.
}
\examples{
library(MASS)
library(LOGIT)
data(medpar)
mylogit <- glm( died ~  los + white + hmo, family=binomial, data=medpar)
summary(mylogit)
medpar2 <- na.omit(medpar)
hlGOF.test(medpar2$died, predict(mylogit,medpar2, type="response"), breaks=12)
}
\author{
Joseph M. Hilbe, Arizona State University, Robert LaBudde,
Institute for Statisical Education (Statistics.com), provided initial code
for this function for Hilbe, Logistic Regression Models, text.
}
\references{
Hilbe, J. M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.

Hilbe, J. M. (2009), Logistic Regression Models, Chapman & Hall/CRC.
}
\seealso{
\code{\link{glm}}
}
\keyword{models}

