% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_tests.R
\name{exponential_rate_one_sample}
\alias{exponential_rate_one_sample}
\title{Test the rate parameter of a exponential distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
exponential_rate_one_sample(
  x,
  rate,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{rate}{a number indicating the tested value of rate.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the rate parameter of a exponential distribution.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rexp(100, 1)
exponential_rate_one_sample(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rexp(100, 3)
exponential_rate_one_sample(x, 1, "greater")
}
