% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_gaussian_tests.R
\name{inverse_gaussian_shape_one_way}
\alias{inverse_gaussian_shape_one_way}
\title{Test the equality of shape parameters of inverse gaussian distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
inverse_gaussian_shape_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of shape parameters of inverse gaussian distributions.
}
\details{
\itemize{
\item Null: Null: All shapes are equal. (shape_1 = shape_2 ... shape_k).
\item Alternative: At least one shape is not equal.
}
}
\examples{
library(LRTesteR)
library(statmod)

# Null is true
set.seed(1)
x <- rinvgauss(n = 150, mean = 1, shape = 2)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
inverse_gaussian_shape_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(
  rinvgauss(n = 50, mean = 1, shape = 1),
  rinvgauss(n = 50, mean = 1, shape = 3),
  rinvgauss(n = 50, mean = 1, shape = 4)
)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
inverse_gaussian_shape_one_way(x, fctr, .95)
}
