% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_functions.R
\name{Gibbs_estimator}
\alias{Gibbs_estimator}
\title{Wrapper around the Gibbs Sampler that returns formatted liability estimates for the proband}
\usage{
Gibbs_estimator(cov, tbl, out, tol = 0.01, burn_in = 1000)
}
\arguments{
\item{cov}{Covariance (kinship matrix times heritability with corrected diagonal) matrix}

\item{tbl}{Tibble with lower and upper bounds for the Gibbs sampler}

\item{out}{Vector indicating if genetic ans/or full liabilities should be estimated}

\item{tol}{Convergence criteria, tolerance}

\item{burn_in}{Number of burn-in iterations}
}
\value{
Formatted liability estimate(s) and standard error(s) of the mean for the proband.
}
\description{
Wrapper around the Gibbs Sampler that returns formatted liability estimates for the proband
}
\examples{
# uninformative sampling:
Gibbs_estimator(cov = diag(3), tbl = tibble::tibble(lower = rep(-Inf, 3),
upper = rep(Inf, 3)), out = 1:2, tol = 0.01, burn_in = 1000)
}
