% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_tune.R
\name{def_tune}
\alias{def_tune}
\title{Define tuning parameters for regularization during integrative clustering}
\usage{
def_tune(Rho_G = -9, Rho_Z_InvCov = 0, Rho_Z_CovMu = 0,
  Select_G = FALSE, Select_Z = FALSE)
}
\arguments{
\item{Rho_G}{Penalty for selection on genetic data, numeric, default is -9 using a sequence of penalties}

\item{Rho_Z_InvCov}{Penalty for the inverse of covariance of biomarkers, numeric, default is 0}

\item{Rho_Z_CovMu}{Penalty for the product of covariance and mean of biomarkers, numeric, default is 0}

\item{Select_G}{Flag to do model selection on genetic data, default is FALSE}

\item{Select_Z}{Flag to do model selection on biomarker data, default is FALSE}
}
\value{
A list of tuning parameters and settings will be returned for integrative clustering.
}
\description{
Defines selection options and tuning parameters in \code{\link{est_lucid}}, \code{\link{sem_lucid}} fitting.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
