% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_tol.R
\name{def_tol}
\alias{def_tol}
\title{Define maximum number of iteration and convergence}
\usage{
def_tol(
  MAX_ITR = 100,
  MAX_TOT_ITR = 10000,
  reltol = 1e-08,
  tol_b = 1e-04,
  tol_m = 1e-04,
  tol_s = 1e-04,
  tol_g = 1e-04,
  tol_p = 1e-04,
  tol_sem = 0.001
)
}
\arguments{
\item{MAX_ITR}{Maximum number of iterations, integer, default is 100}

\item{MAX_TOT_ITR}{Maximum number of total iterations, integer, default is 10000}

\item{reltol}{Convergence cut-off using a relative tolerance, default is 1e-8}

\item{tol_b}{Convergence criteria of \eqn{\beta}, genetic effects parameter, default is 1e-4}

\item{tol_m}{Convergence criteria of \eqn{\mu}, biomarker mean effects parameters, default is 1e-4}

\item{tol_s}{Convergence criteria of \eqn{\Sigma}, biomarker covariance matrix, default is 1e-4}

\item{tol_g}{Convergence criteria of \eqn{\gamma}, outcome effects parameter, default is 1e-4}

\item{tol_p}{Convergence criteria of the probability of latent clusters, default is 1e-4}

\item{tol_sem}{Convergence criteria of SEM, default is 1e-3}
}
\value{
A list of tolerance settings will be returned for integrative clustering.
}
\description{
Defines tolerance settings in \code{\link{est_lucid}}, \code{\link{sem_lucid}} , & \code{\link{tune_lucid}} fitting.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
