% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWchi2.R
\name{LWchi2}
\alias{LWchi2}
\title{Chi-Squared Statistic}
\usage{
LWchi2(obsn, expn, totn)
}
\arguments{
\item{obsn}{A numeric vector of observed counts.}

\item{expn}{A numeric vector of expected counts, the same length as \code{obsn}.}

\item{totn}{A numeric vector of total counts possible, the same length as \code{obsn}.}
}
\value{
A list of length two.
  The first element is a numeric vector of length three:
    \code{chistat}, chi-squared statistic;
    \code{df}, degrees of freedom; and
    \code{pval}, P value.
  The second element is a numeric vector the same length as \code{obsn},
    containing \strong{total} contributions to the chi-squared.  To get the
    \strong{individual} contributions to the chi-squared as reported in
    Litchfield and Wilcoxon (1949), divide by \code{totn}.
}
\description{
Calculate the chi-squared statistic from observed and expected counts
using the Litchfield and Wilcoxon (1949) approach.
}
\details{
The denominator of Litchfield and Wilcoxon's (1949) chi-squared estimate
  is the minimum of the \code{expn} and (\code{totn} - \code{expn})
  following their Nomograph No. 1.  This ensures that the same chi-squared
  value is calculated regardless of which proportion is reported (e.g.,
  affected vs. not affected).
}
\examples{
LWchi2(c(10, 8, 3), c(7, 7, 7), c(12, 12, 12))
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}
\seealso{
\code{\link{chisq.test}}.
}
