% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predLinesLP.R
\name{predLinesLP}
\alias{predLinesLP}
\title{Add Litchfield and Wilcoxon Predictions to a Plot}
\usage{
predLinesLP(fit, ...)
}
\arguments{
\item{fit}{A list of length three containing the result of a Litchfield and
Wilcoxon model fit, typically the output from \code{\link{LWestimate}}.}

\item{...}{Additional arguments to \code{\link{abline}} and \code{\link{lines}}.}
}
\value{
A solid fitted line is added to the plot.  Dashed lines are added to the
    plot representing the \strong{horizontal} 95\% confidence intervals
    for the predicted dose to elicit a given percent affected.
}
\description{
Add predictions from a Litchfield and Wilcoxon model fit to
a plot of the results of a dose-effect experiment on the log10-probit scale.
}
\examples{
dose <- c(0.0625, 0.125, 0.25, 0.5, 1)
ntested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=dose, ntot=ntested, nfx=nalive)
plotDELP(mydat)
myfit <- LWestimate(fitLWauto(mydat), mydat)
predLinesLP(myfit)
}
\seealso{
\code{\link{plotDELP}}, \code{\link{plotDE}}, \code{\link{predLines}}
}
