% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MLE_LambertW}
\alias{MLE_LambertW}
\title{Maximum Likelihood Estimation for Lambert W\eqn{ \times} F distributions}
\usage{
MLE_LambertW(y, distname, type = c("h", "s", "hh"), theta.fixed = list(alpha
  = 1), theta.init = get_initial_theta(y, distname = distname, type = type,
  theta.fixed = theta.fixed), hessian = TRUE, return.estimate.only = FALSE,
  optim.fct = c("optim", "nlm", "solnp"), not.negative = FALSE)
}
\arguments{
\item{y}{a numeric vector of real values.}

\item{distname}{string; name of input distribution; see \code{\link{get_distnames}}.}

\item{type}{type of Lambert W \eqn{\times} F distribution: skewed \code{"s"};
heavy-tail \code{"h"}; or skewed heavy-tail \code{"hh"}.}

\item{theta.fixed}{a list of fixed parameters in the optimization; default
only \code{alpha = 1}.}

\item{theta.init}{a list containing the starting values of \eqn{(\alpha,
\boldsymbol \beta, \gamma, \delta)} for the numerical optimization; default:
see \code{\link{get_initial_theta}}.}

\item{hessian}{indicator for returning the (numerically obtained) Hessian at
the optimum; default: \code{TRUE}. If the \pkg{numDeriv} package is
available it uses the \code{numDeriv::hessian()} function; if not, it uses
\code{stats::optim(..., hessian = TRUE)}.}

\item{return.estimate.only}{logical; if \code{TRUE}, only a named flattened
vector of \eqn{\widehat{\theta}_{MLE}}
will be returned (only the estimated, non-fixed values). This is especially useful
for simulations where it is usually not necessary to give a nicely organized
output, but only the estimated parameters. Default: \code{FALSE}.}

\item{optim.fct}{string; which R optimization function should be used. Either
\code{'optim'} (default), \code{'nlm'}, or \code{'solnp'} from the
\pkg{Rsolnp} package (if available).  Note that if
\code{'nlm'} is used, then \code{not.negative = TRUE} will be set automatically.}

\item{not.negative}{logical; if \code{TRUE}, it restricts \code{delta} or \code{gamma} to
the non-negative reals. See \code{\link{theta2unbounded}} for details.}
}
\value{
A list of class \code{LambertW_fit}:
\item{data}{ data \code{y},}
\item{loglik}{R function; log-likelihood function,}
\item{loglik.opt}{scalar; log-likelihood evaluated at the optimum,}
\item{theta.init}{list; starting values for numerical optimization,}
\item{beta}{ estimated \eqn{\boldsymbol \beta} vector of the input distribution via Lambert W MLE
 (In general this is not exactly identical to \eqn{\neq \widehat{\boldsymbol \beta}_{MLE}} for
 the input data), }
\item{theta}{list; MLE for \eqn{\theta}, }
\item{type}{see Arguments,}
\item{hessian}{Hessian matrix; used to calculate standard errors (only if \code{hessian = TRUE},
otherwise \code{NULL}),}
\item{call}{function call,}
\item{distname}{see Arguments,}
\item{message}{message from the optimization method. What kind of convergence?,}
\item{method}{estimation method; here \code{"MLE"}.}
}
\description{
Maximum Likelihood Estimation (MLE) for Lambert W \eqn{\times F} distributions
computes \eqn{\widehat{\theta}_{MLE}}.

For \code{type = "s"}, the skewness parameter \eqn{\gamma} is estimated and \eqn{\delta
= 0} is held fixed; for \code{type = "h"} the one-dimensional \eqn{\delta}
is estimated and \eqn{\gamma = 0} is held fixed; and finally for \code{type
= "hh"} the 2-dimensional \eqn{\delta} is estimated and \eqn{\gamma = 0} is
held fixed.

By default \eqn{\alpha = 1} is fixed for any \code{type}. If you want to
also estimate \eqn{\alpha} (for \code{type = "h"} or \code{"hh"})
set \code{theta.fixed = list()}.
}
\examples{
# See ?LambertW-package
}
\keyword{optimize}

