% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{alpha_curve}
\alias{alpha_curve}
\title{Cronbach-Mesbah Curve}
\usage{
alpha_curve(data)
}
\arguments{
\item{data}{a Dataframe that holds the test response data}
}
\value{
The number of items used to calculate the coefficient.

The maximum value of the alpha coefficient calculated at each step.

The item removed at each step.

Tue Cronbach-Mesbah curve plot.
}
\description{
Assess the unidimensionality of a set of items from alpha coefficient.
}
\details{
Constructs the curve by iteration:\cr
1. Compute alpha using all items.\cr
2. Remove one item from the scale. The removed item is the one which leaves the scale
with its maximum alpha value. If we remove a bad item, the alpha  coefficient  will
increase. Whereas if we remove a good item, the alpha must decrease.\cr
3. Repeat until only  two items remain.\cr
This function was extracted from CMC_1.0 package.
}
\references{
Cameletti, M. & Caviezel, V. (2010). Checking the unidimensionality in R
using the Cronbach-Mesbah curve.

Mesbah, M. (2010). Statistical quality of life. In "Method and Applications of Statistics in the 
Life and Health Sciences", N. BalakrishnanEd., Wiley, pp. 839-864.
}

