% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterDistance.R
\name{clusterDistance}
\alias{clusterDistance}
\title{To calculate the distance between clusters.}
\usage{
clusterDistance(cluster1, cluster2, approach, distance)
}
\arguments{
\item{cluster1}{is a matrix}

\item{cluster2}{is a matrix}

\item{approach}{is a string. Type of function to apply.}

\item{distance}{is a string. Type of distance to use.}
}
\value{
Distance between clusters.
}
\description{
To calculate the distance between clusters depending on the approach and distance type.
}
\details{
This function is part of the hierarchical clusterization method. The function calculates the
final distance between \code{cluster1} and \code{cluster2} applying the approach definition, using the distance type given.

\code{approach} indicates the algorithm used to get the value. \code{distance} indicates the distance used to get the value. Possible values: {\code{'MAX'},
\code{'MIN'}, \code{'AVG'}}.
}
\examples{

cluster1 <- matrix(c(1,2),ncol=2)
cluster2 <- matrix(c(1,4),ncol=2)

clusterDistance.details(cluster1,cluster2,'AVG','MAN')

clusterDistance.details(cluster1,cluster2,'MAX','OCT')

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
