% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distances}
\alias{distances}
\title{To calculate distances applying weights.}
\usage{
distances(cluster1, cluster2, distance, weight)
}
\arguments{
\item{cluster1}{is a matrix.}

\item{cluster2}{is a matrix.}

\item{distance}{is a string. The distance type to apply.}

\item{weight}{is a numeric vector.}
}
\value{
Distance value applying weights.
}
\description{
To calculate distances between two clusters applying weights depending on the distance type.
}
\details{
This function calculates distance applying \code{distance} type and applying each weight to its characteristic.

Distance type could be \code{EUC}, \code{MAN}, \code{CAN}, \code{CHE} or  \code{OCT}.
}
\examples{

cluster1 <- matrix(c(2,3))
cluster2 <- matrix(c(4,5))

weight1 <- c(0.6,0.4)
weight2 <- c(2,4)

distances(cluster1, cluster2, 'MAN', weight1)

distances(cluster1, cluster2, 'CHE', weight2)

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
