% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KruskalWallis.R
\name{KruskalWallis}
\alias{KruskalWallis}
\alias{ksample.kw}
\title{Kruskal-Wallis Test}
\description{
Performs Kruskal-Wallis test on samples.
}
\examples{
pmt(
    "ksample.kw", type = "asymp"
)$test(Table3.2.2)$print()

t <- pmt(
    "ksample.kw", type = "permu"
)$test(Table3.2.3)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:KSampleTest]{LearnNonparam::KSampleTest}} -> \code{KruskalWallis}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KruskalWallis-new}{\code{KruskalWallis$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KruskalWallis-new"></a>}}
\if{latex}{\out{\hypertarget{method-KruskalWallis-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{KruskalWallis} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KruskalWallis$new(
  type = c("permu", "asymp"),
  scoring = c("rank", "vw", "expon"),
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{scoring}}{a character string specifying the scoring system.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{KruskalWallis} object.
}
}
}
