% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneWay.R
\name{OneWay}
\alias{OneWay}
\alias{ksample.oneway}
\title{One-Way Test for Equal Means}
\description{
Performs F statistic based one-way test on samples.
}
\examples{
\donttest{
t <- pmt(
    "ksample.oneway", n_permu = 0
)$test(Table3.1.2)$print()

t$type <- "asymp"
t
}

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:KSampleTest]{LearnNonparam::KSampleTest}} -> \code{OneWay}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OneWay-new}{\code{OneWay$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OneWay-new"></a>}}
\if{latex}{\out{\hypertarget{method-OneWay-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{OneWay} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OneWay$new(type = c("permu", "asymp"), n_permu = 10000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{OneWay} object.
}
}
}
