% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Studentized.R
\name{Studentized}
\alias{Studentized}
\alias{multcomp.studentized}
\title{Multiple Comparison Based on Studentized Statistic}
\description{
Performs studentized statistic based multiple comparison on samples.
}
\examples{
t <- pmt(
    "multcomp.studentized", method = "bonferroni"
)$test(Table3.3.1)$print()

t$type <- "asymp"
t

t$scoring <- "rank"
t

t$method <- "tukey"
t

t$scoring <- "none"
t

t$type <- "permu"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:KSampleTest]{LearnNonparam::KSampleTest}} -> \code{\link[LearnNonparam:MultipleComparison]{LearnNonparam::MultipleComparison}} -> \code{Studentized}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Studentized-new}{\code{Studentized$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Studentized-new"></a>}}
\if{latex}{\out{\hypertarget{method-Studentized-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Studentized} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Studentized$new(
  type = c("permu", "asymp"),
  method = c("bonferroni", "tukey"),
  scoring = c("none", "rank", "vw", "expon"),
  conf_level = 0.95,
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{method}}{a character string specifying whether to use Bonferroni's method or Tukey's HSD method.}

\item{\code{scoring}}{a character string specifying the scoring system.}

\item{\code{conf_level}}{a number between zero and one indicating the family-wise confidence level to use.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Studentized} object.
}
}
}
