% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brown.R
\name{Brown2reference}
\alias{Brown2reference}
\title{Add Brown et al. (2022) reference illuminance to a dataset}
\usage{
Brown2reference(
  dataset,
  MEDI.colname = MEDI,
  Brown.state.colname = State.Brown,
  Brown.rec.colname = Reference,
  Reference.label = "Brown et al. (2022)",
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{dataset}{A dataframe that contains a column with the Brown states}

\item{MEDI.colname}{The name of the column that contains the MEDI values
which are used for checks against the Brown reference illuminance. Must be
part of the dataset.}

\item{Brown.state.colname}{The name of the column that contains the Brown
states. Must be part of the dataset.}

\item{Brown.rec.colname}{The name of the column that will contain the
recommended illuminance. Must not be part of the dataset, otherwise it will
throw an error.}

\item{Reference.label}{The label that will be used for the reference. Expects
a \code{character} scalar.}

\item{overwrite}{If \code{TRUE} (defaults to \code{FALSE}), the function will
overwrite the \code{Brown.rec.colname} column if it already exists.}

\item{...}{Additional arguments that will be passed to \code{\link[=Brown_rec]{Brown_rec()}} and
\code{\link[=Brown_check]{Brown_check()}}. This is only relevant to correct the names of the daytime
states or the thresholds used within these states. See the documentation of
these functions for more information.}
}
\value{
A dataframe on the basis of the \code{dataset} that contains the added
columns.
}
\description{
Adds several columns to a light logger dataset. It requires a column that
contains the Brown states, e.g. "daytime", "evening", and "night". From that
the function will add a column with the recommended illuminance, a column
that checks if the illuminance of the dataset is within the recommended
illuminance levels, and a column that gives a label to the reference.
}
\details{
On a lower level, the function uses \code{\link[=Brown_rec]{Brown_rec()}} and \code{\link[=Brown_check]{Brown_check()}} to
create the required information.
}
\examples{
#add Brown reference illuminance to some sample data
testdata <- tibble::tibble(MEDI = c(100, 10, 1, 300),
                  State.Brown = c("day", "evening", "night", "day"))
Brown2reference(testdata)

}
\references{
https://journals.plos.org/plosbiology/article?id=10.1371/journal.pbio.3001571
}
\seealso{
Other Brown: 
\code{\link{Brown_check}()},
\code{\link{Brown_rec}()},
\code{\link{sleep_int2Brown}()}
}
\concept{Brown}
