% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindelyGeometric.R
\name{plindleygeometric}
\alias{plindleygeometric}
\alias{dlindleygeometric}
\alias{hlindleygeometric}
\alias{qlindleygeometric}
\alias{rlindleygeometric}
\title{LindleyGeometric}
\usage{
plindleygeometric(x, lambda, theta, log.p = FALSE)

dlindleygeometric(x, lambda, theta)

hlindleygeometric(x, lambda, theta)

qlindleygeometric(p, lambda, theta)

rlindleygeometric(n, lambda, theta)
}
\arguments{
\item{x}{vector of positive quantiles.}

\item{lambda}{positive parameter}

\item{theta}{positive parameter.}

\item{log.p}{logical; If \code{TRUE}, probabilities \eqn{p} are given as \eqn{log(p)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{plindleygeometric} gives the culmulative distribution function

\code{dlindleygeometric} gives the probability density function

\code{hlindleygeometric} gives the hazard rate function

\code{qlindleygeometric} gives the quantile function

\code{rlindleygeometric} gives the random number generatedy by distribution

Invalid arguments will return an error message.
}
\description{
distribution function, density function, hazard rate function, quantile function, random number generation
}
\details{
Probability density function
\deqn{f(x)=\frac{\theta\lambda^2}{(\lambda+1)A(\theta)}(1+x)exp(-\lambda x)A^{'}(\phi)}

Cumulative distribution function
\deqn{F(x)=\frac{A(\phi)}{A(\theta)}}

Quantile function
\deqn{F^{-1}(p)=-1-\frac{1}{\lambda}-\frac{1}{\lambda}W_{-1}\left\{\frac{\lambda+1}{exp(\lambda+1)}\left[\frac{1}{\theta}A^{-1}\{pA(\theta)\}-1\right]\right\}}

Hazard rate function
\deqn{h(x)=\frac{\theta\lambda^2}{1+\lambda}(1+x)exp(-\lambda x)\frac{A^{'}(\phi)}{A(\theta)-A(\phi)}}

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function. \eqn{A(\theta)=\sum_{n=1}^{\infty}a_n\theta^{n}} is given by specific power series distribution.
Note that \eqn{x>0, \lambda>0}  for all members in Lindley Power Series distribution.
\eqn{0<\theta<1}  for Lindley-Geometric distribution, Lindley-logarithmic distribution, Lindley-Negative Binomial distribution.
\eqn{\theta>0} for Lindley-Poisson distribution, Lindley-Binomial distribution.
}
\examples{
set.seed(1)
lambda = 1
theta = 0.5
n = 10
x <- seq(from = 0.1,to = 6,by = 0.5)
p <- seq(from = 0.1,to = 1,by = 0.1)
plindleygeometric(x, lambda, theta, log.p = FALSE)
dlindleygeometric(x, lambda, theta)
hlindleygeometric(x, lambda, theta)
qlindleygeometric(p, lambda, theta)
rlindleygeometric(n, lambda, theta)
}
\references{
Ghitany, M. E., Atieh, B., Nadarajah, S., (2008). Lindley distribution and its application. \emph{Mathematics and Computers in Simulation}, \bold{78}, (4), 49-506.

Jodra, P., (2010). Computer generation of random variables with Lindley or Poisson-Lindley distribution via the Lambert W function. \emph{Mathematics and Computers in Simulation}, \bold{81}, (4), 851-859.

Lindley, D. V., (1958). Fiducial distributions and Bayes' theorem. \emph{Journal of the Royal Statistical Society. Series B. Methodological}, \bold{20}, 102-107.

Lindley, D. V., (1965). \emph{Introduction to Probability and Statistics from a Bayesian View-point, Part II: Inference}. Cambridge University Press, New York.
}
\author{
Saralees Nadarajah & Yuancheng Si \email{yuancheng.si@manchester.ac.uk}

Peihao Wang
}
