% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DLindley.R
\name{DLindley}
\alias{DLindley}
\alias{ddlindley}
\alias{fires}
\alias{pdlindley}
\alias{qdlindley}
\alias{rdlindley}
\title{One-Parameter Discrete Lindley Distribution}
\source{
[d-p-q-r]dlindley are calculated directly from the definitions. \code{rdlindley} uses the discretize values.
}
\usage{
ddlindley(x, theta, log = FALSE)

pdlindley(q, theta, lower.tail = TRUE, log.p = FALSE)

qdlindley(p, theta, lower.tail = TRUE, log.p = FALSE)

rdlindley(n, theta)
}
\arguments{
\item{x, q}{vector of integer positive quantiles.}

\item{theta}{positive parameter.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{ddlindley} gives the probability mass function, \code{pdlindley} gives the distribution function, \code{qdlindley} gives the quantile function and \code{rdlindley} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Probability mass function, distribution function, quantile function and random number generation for the one-parameter discrete Lindley distribution with parameter theta.
}
\details{
Probability mass function
\deqn{P\left( X=x\mid \theta \right) =\sum\limits_{i=0}^{1}\left( -1\right) ^{i}\left( 1+\frac{\theta }{1+\theta }\left( x+i\right) \right) e^{-\theta \left( x+i\right) }}
}
\examples{
set.seed(1)
x <- rdlindley(n = 1000, theta = 1.5)
plot(table(x) / sum(table(x)))
points(unique(x),ddlindley(unique(x), theta = 1.5))

## fires in Greece data (from Bakouch et al., 2014)
data(fires)
library(fitdistrplus)
fit <- fitdist(fires, 'dlindley', start = list(theta = 0.30), discrete = TRUE)
gofstat(fit, discrete = TRUE)
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Bakouch, H. S., Jazi, M. A. and Nadarajah, S. (2014). A new discrete distribution. \emph{Statistics: A Journal of Theoretical and Applied Statistics}, \bold{48}, 1, 200-240.

Gomez-Deniz, E. and Calderín-Ojeda, E. (2013). The discrete Lindley distribution: properties and applications. \emph{Journal of Statistical Computation and Simulation}, \bold{81}, 11, 1405-1416.
}
\seealso{
\code{\link[LindleyR]{Lindley}}.
}

