% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAMLindley.R
\name{GAMLindley}
\alias{GAMLindley}
\alias{dgamlindley}
\alias{hgamlindley}
\alias{pgamlindley}
\alias{qgamlindley}
\alias{rgamlindley}
\title{Gamma Lindley Distribution}
\source{
[d-h-p-q-r]gamlindley are calculated directly from the definitions. \code{rgamlindley} uses either a mixture of gamma and one-parameter Lindley distributions or the quantile function.
}
\usage{
dgamlindley(x, theta, alpha, log = FALSE)

pgamlindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qgamlindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rgamlindley(n, theta, alpha, mixture = TRUE)

hgamlindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical; If TRUE, (default), random deviates are generated from a mixture of gamma and one-parameter Lindley distributions, otherwise from the quantile function.}
}
\value{
\code{dgamlindley} gives the density, \code{pgamlindley} gives the distribution function, \code{qgamlindley} gives the quantile function, \code{rgamlindley} generates random deviates and \code{hgamlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the Gamma Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta ,\alpha )=\frac{{\theta }^{2}}{\alpha \left( 1+\theta \right) }\left[ \left( \alpha +\alpha \theta -\theta \right) x+1\right] e{^{-\theta x}}}

Cumulative distribution function
\deqn{F(x\mid \theta ,\alpha )=\frac{1}{\alpha \left( 1+\theta \right) }\left[\left( \alpha +\alpha \theta -\theta \right) \left( 1+\theta x\right) +\theta \right] e{^{-\theta  x}}}

Quantile function
\deqn{Q(p\mid \theta ,\alpha )=-\frac{\alpha \left( 1+\theta \right) }{\theta \left[ \left( \alpha +\alpha \theta -\theta \right) \right] }-\frac{1}{\theta }W_{-1}\left( {\frac{\left( 1+\theta \right) \alpha \left(p-1\right) }{\alpha +\alpha \theta -\theta }}e{{^{-{\frac{\left( 1+\theta \right) \alpha }{\alpha \theta +\alpha -\theta }}}}}\right) }

Hazard rate function
\deqn{h(x\mid \theta ,\alpha )=\frac{{\theta }^{2}\left[ \left( \alpha +\alpha \theta -\theta \right) x+1\right] }{{\theta }\left( \alpha +\alpha \theta-\theta \right) x+\alpha \left( 1+\theta \right) }}

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.

\bold{Particular case:} \eqn{\alpha = 1} the one-parameter Lindley distribution.
}
\examples{
set.seed(1)
x <- rgamlindley(n = 1000, theta = 1.5, alpha = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dgamlindley(S, theta = 1.5, alpha = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pgamlindley(q, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
pgamlindley(q, theta = 1.5, alpha = 1.5, lower.tail = FALSE)
qgamlindley(p, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
qgamlindley(p, theta = 1.5, alpha = 1.5, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'gamlindley', start = list(theta = 1.5, alpha = 1.5))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Nedjar, S. and Zeghdoudi (2016). On gamma Lindley distribution: Properties and simulations. \emph{Journal of Computational and Applied Mathematics}, \bold{298}, 167-174.

Zeghdoudi, H, and Nedjar, S. (2015) Gamma Lindley distribution and its application. \emph{Journal of Applied Probability and Statistics}, \bold{11}, (1), 1-11.
}
\seealso{
\code{\link[lamW]{lambertWm1}}.
}

