% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idTGpos.R
\name{idTGpos}
\alias{idTGpos}
\title{Triacylglycerols (TG) annotation for ESI+}
\usage{
idTGpos(MS1, MSMS1, MSMS2 = data.frame(), ppm_precursor = 5,
  ppm_products = 10, rttol = 3, rt = c(min(MS1$RT), max(MS1$RT)),
  adducts = c("M+NH4", "M+Na"), clfrags = c(), clrequired = c(),
  ftype = c(), chainfrags_sn1 = c("cbdiff-dg_M+H-H2O"),
  chainfrags_sn2 = c("cbdiff-dg_M+H-H2O"),
  chainfrags_sn3 = c("cbdiff-dg_M+H-H2O"), intrules = c("Unknown"),
  rates = c(), intrequired = c(T), dbs = list(tgdb = LipidMS::tgdb, fadb =
  LipidMS::fadb, dgdb = LipidMS::dgdb, adductsTable = LipidMS::adductsTable))
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{MSMS1}{data frame cointaining all peaks from the low energy function.
It must have three columns: m.z, RT and int.}

\item{MSMS2}{data frame cointaining all peaks from the high energy
function if it is the case. It must have three columns: m.z, RT and int.
Optional.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for TG in ESI+. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments in sn1 position. See \link{chainFrags} for details.}

\item{chainfrags_sn2}{character vector containing the fragmentation rules for
the chain fragments in sn2 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn1 chains.}

\item{chainfrags_sn3}{character vector containing the fragmentation rules for
the chain fragments in sn3 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn2 chains.}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}. If some intensity rules should be employed to
identify the chains position but they are't known yet, use "Unknown". If it
isn't required, leave an empty vector.}

\item{rates}{character vector with the expected rates between fragments given
as a string (i.e. "3/1"). See \link{checkIntensityRules}.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be changed. If data bases have
been customized using \link{createLipidDB}, they also have to be modified
here.}
}
\value{
list with TG annotations (results) and some additional information
(class fragments and chain fragments).
}
\description{
TG identification based on fragmentation patterns for LC-MS/MS
AIF data acquired in positive mode.
}
\details{
\code{idTGpos} function involves 5 steps. 1) FullMS-based
identification of candidate TG as M+NH4 and M+Na (for long chain TGs
only those that are found as M+NH4 and M+Na are kept to avoid FP).
2) Search of TG class fragments: there are no class fragment by default.
3) Search of specific fragments that inform about the FA chains: DGs resulting
from the loss of FA chains as M+H-H2O. Only those with a relative intensity
to the precursor greater than 0.1 are kept to avoid FP. 4) Look for possible
chains structure based on the combination of chain fragments. 5) Check
intensity rules to confirm chains position. In the case of TG, FA position
level still needs some improvements.

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (Subclass,
FA level, where chains are known but not their positions, or FA position
level).
}
\note{
Isotopes should be removed before identification to avoid false
positives.
This function has been writen based on fragmentation patterns observed for
two different platforms (QTOF 6550 from Agilent and Sinapt G2-Si from Waters),
but it may need to be customized for other platforms or acquisition settings.
}
\examples{
\donttest{idTGpos(MS1 = LipidMS::mix_pos_fullMS, MSMS1 = LipidMS::mix_pos_Ce20,
MSMS2 = LipidMS::mix_pos_Ce40)}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
