% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{compute_EIIP}
\alias{compute_EIIP}
\title{Extract the EIIP-derived features}
\usage{
compute_EIIP(
  Sequences,
  label = NULL,
  spectrum.percent = 0.1,
  quantile.probs = seq(0, 1, 0.25)
)
}
\arguments{
\item{Sequences}{A FASTA file loaded by function  \code{\link[seqinr]{read.fasta}} of
\code{\link[seqinr]{seqinr-package}}.}

\item{label}{Optional. String. Indicate the label of the sequences such as
"NonCoding", "Coding".}

\item{spectrum.percent}{Numeric specifying the percentage of the sorted power spectrum that be
used to calculate the quantile-based features. For example, if \code{spectrum.percent = 0.1},
the top 10\% percent of the sorted power spectrum will be used to compute the quantiles.}

\item{quantile.probs}{Numeric. The probabilities with values in [0,1].}
}
\value{
A dataframe including the EIIP-derived features.
}
\description{
This function can extract EIIP-derived features proposed by Han et al (2018).
}
\details{
The function \code{compute_EIIP} can extract EIIP (electron-ion interaction pseudo-potential) features including:
signal at 1/3 position (\code{Signal.Peak}), average power (\code{Average.Power}), signal to noise ratio (\code{SNR}),
and quantile-based features of one specified percentage of the sorted power spectrum
(e.g. \code{0\%}, \code{20\%}, \code{40\%}, \code{60\%}, \code{70\%},
\code{100\%} when \code{quantile.probs = seq(0, 1, 0.2)} and \code{spectrum.percent =} \code{0.1}).

In method LncFinder, EIIP features includes \code{Signal.Peak}, \code{SNR}, 0\% (\code{Signal.Min}),
25\% (\code{Singal.Q1}, 50\% \code{Signal.Q2}), and 75\% (\code{Signal.Max}) of the top 10\% sorted
power spectrum, i.e. \code{quantile.prob} \code{= seq(0, 1, 0.25)} and \code{spectrum.percent = 0.1}.
}
\section{References}{

Siyu Han, Yanchun Liang, Qin Ma, Yangyi Xu, Yu Zhang, Wei Du, Cankun Wang & Ying Li.
LncFinder: an integrated platform for long non-coding RNA identification utilizing
sequence intrinsic composition, structural information, and physicochemical property.
\emph{Briefings in Bioinformatics}, 2019, 20(6):2009-2027.

Lalović, Dragutin, and Veljko Veljković.
The global average DNA base composition of coding regions may be determined by the electron-ion interaction potential.
\emph{Biosystems}, 1990, 23(4):311-316.

Achuthsankar S Nair & Sivarama Pillai Sreenadhan.
A coding measure scheme employing electron-ion interaction pseudopotential (EIIP).
\emph{Bioinformation}, 2006, 1(6):197-202.
}

\examples{
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

EIIP_res <- compute_EIIP(Seqs, label = "NonCoding", spectrum.percent = 0.25,
                         quantile.probs = seq(0, 1, 0.25))

}
\seealso{
\code{\link{extract_features}}
}
\author{
HAN Siyu
}
