% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_analysis.R
\name{indicator_analysis}
\alias{indicator_analysis}
\title{Indicator Analysis}
\usage{
indicator_analysis(taxobj, taxlevel, func = "r.g", reads = FALSE)
}
\arguments{
\item{taxobj}{Configured tax summary objects.See in \code{\link{object_config}}.}

\item{taxlevel}{taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").}

\item{func}{Default: "r.g".The function to use for the indicator analysis, see in \code{\link[indicspecies]{multipatt}}}

\item{reads}{A logical value indicating whether the input data is in terms of raw reads (TRUE) or relative abundance (FALSE)}
}
\value{
A data frame with the results of the indicator analysis, including adjusted p-values, tags and taxonomic information.
}
\description{
Performs the indicator analysis based on taxonomic summary object
}
\note{
This function depends on the following packages: indicspecies, permute.
These packages are not automatically loaded and should be installed before using this function.
}
\examples{
data("Two_group")
if (requireNamespace("indicspecies", quietly = TRUE) &&
    requireNamespace("permute", quietly = TRUE)) {
  set.seed(999)
  indicator_results <- indicator_analysis(
    taxobj = Two_group,
    taxlevel = "Genus"
  )
  head(indicator_results)
}
}
\seealso{
\code{\link[indicspecies]{multipatt}}, \code{\link[permute]{how}}
}
