% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Spectrum-class.R
\docType{class}
\name{RLum.Data.Spectrum-class}
\alias{RLum.Data.Spectrum-class}
\alias{get_RLum,RLum.Data.Spectrum-method}
\alias{names_RLum,RLum.Data.Spectrum-method}
\alias{set_RLum,RLum.Data.Spectrum-method}
\alias{show,RLum.Data.Spectrum-method}
\title{Class \code{"RLum.Data.Spectrum"}}
\usage{
\S4method{show}{RLum.Data.Spectrum}(object)

\S4method{set_RLum}{RLum.Data.Spectrum}(class, originator, .uid, .pid,
  recordType = "Spectrum", curveType = NA_character_, data = matrix(),
  info = list())

\S4method{get_RLum}{RLum.Data.Spectrum}(object, info.object)

\S4method{names_RLum}{RLum.Data.Spectrum}(object)
}
\arguments{
\item{object}{[\code{show_RLum}][\code{get_RLum}][\code{names_RLum}] an object of
class \code{\linkS4class{RLum.Data.Spectrum}}}

\item{class}{[\code{set_RLum}] \code{\link{character}} (automatic): name of the \code{RLum} class to create.}

\item{originator}{\code{\link{character}} (automatic): contains the name of the calling function
(the function that produces this object); can be set manually.}

\item{.uid}{[\code{set_RLum}] \code{\link{character}} (automatic): sets an unique ID for this object
using the internal C++ function \code{.create_UID}.}

\item{.pid}{[\code{set_RLum}] \code{\link{character}} (with default): option to provide a parent id for nesting
at will.}

\item{recordType}{[\code{set_RLum}] \code{\link{character}}: record type (e.g. "OSL")}

\item{curveType}{[\code{set_RLum}] \code{\link{character}}: curve type (e.g. "predefined" or "measured")}

\item{data}{[\code{set_RLum}] \code{\link{matrix}}: raw curve data. If data is of
type \code{RLum.Data.Spectrum}, this can be used to re-construct the object.}

\item{info}{[\code{set_RLum}] \code{\link{list}}: info elements}

\item{info.object}{[\code{get_RLum}] \code{\link{character}} (optional): the name of the info
object to be called}
}
\value{
\bold{\code{[set_RLum]}}\cr

An object from the class \code{RLum.Data.Spectrum}

\bold{\code{get_RLum}}\cr

(1) A \code{\link{matrix}} with the spectrum values or \cr
(2) only the info object if \code{info.object} was set.\cr

\bold{\code{names_RLum}}\cr

The names of the info objects
}
\description{
Class for representing luminescence spectra data (TL/OSL/RF).
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Data.Spectrum} object

\item \code{set_RLum}: Construction method for RLum.Data.Spectrum object. The slot info is optional
and predefined as empty list by default

\item \code{get_RLum}: Accessor method for RLum.Data.Spectrum object. The argument info.object
is optional to directly access the info elements. If no info element name
is provided, the raw curve data (matrix) will be returned

\item \code{names_RLum}: Returns the names info elements coming along with this curve object
}}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class \code{\link{character}} containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class \code{\link{character}} containing curve type, allowed values
are measured or predefined}

\item{\code{data}}{Object of class \code{\link{matrix}} containing spectrum (count) values.
Row labels indicate wavelength/pixel values, column labels are temperature or time values.}

\item{\code{info}}{Object of class \code{\link{list}} containing further meta information objects}
}}
\note{
The class should only contain data for a single spectra data set. For
additional elements the slot \code{info} can be used. Objects from this class are automatically
created by, e.g., \code{\link{read_XSYG2R}}
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{set_RLum("RLum.Data.Spectrum", ...)}.
}

\section{Class version}{
 0.4.0
}
\examples{

showClass("RLum.Data.Spectrum")

##show example data
data(ExampleData.XSYG, envir = environment())
TL.Spectrum

##show data matrix
get_RLum(TL.Spectrum)

##plot spectrum
\dontrun{
plot_RLum(TL.Spectrum)
}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
}
\seealso{
\code{\linkS4class{RLum}}, \code{\linkS4class{RLum.Data}},
\code{\link{plot_RLum}}
}
\keyword{classes}

