% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_R2TIFF.R
\name{write_R2TIFF}
\alias{write_R2TIFF}
\title{Export RLum.Data.Image and RLum.Data.Spectrum objects to TIFF Images}
\usage{
write_R2TIFF(object, file = tempfile(), norm = 65535, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Image} or \linkS4class{RLum.Data.Spectrum} object (\strong{required}):
input object, can be a \link{list} of such objects}

\item{file}{\link{character} (\strong{required}): the file name and path}

\item{norm}{\link{numeric} (\emph{with default}): normalisation values. Values in TIFF files must range between 0-1, however, usually
in imaging applications the pixel values are real integer count values. The normalisation to the
to the highest 16-bit integer values -1 ensures that the numerical values are retained in the exported
image. If \code{1} nothing is normalised.}

\item{...}{further arguments to be passed to \link[tiff:writeTIFF]{tiff::writeTIFF}.}
}
\value{
A TIFF file
}
\description{
Simple wrapper around \link[tiff:writeTIFF]{tiff::writeTIFF} to export suitable
RLum-class objects to TIFF images. Per default 16-bit TIFF files are exported.
}
\section{Function version}{
 0.1.0
}

\examples{
data(ExampleData.RLum.Data.Image, envir = environment())
write_R2TIFF(ExampleData.RLum.Data.Image, file = tempfile())

}
\seealso{
\link[tiff:writeTIFF]{tiff::writeTIFF}, \linkS4class{RLum.Data.Image}, \linkS4class{RLum.Data.Spectrum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2024. write_R2TIFF(): Export RLum.Data.Image and RLum.Data.Spectrum objects to TIFF Images. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.25. https://r-lum.github.io/Luminescence/
}

\keyword{IO}
