/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import com.sosnoski.util.hashset.IntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.seeding.EveryNodeSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Graph;

public class UnusedNodesSeedGenerator
extends EveryNodeSeedGenerator {
    public UnusedNodesSeedGenerator() {
    }

    public UnusedNodesSeedGenerator(Graph graph) {
        super(graph);
    }

    public SeedIterator iterator() {
        return new IteratorImpl();
    }

    private class IteratorImpl
    extends SeedIterator {
        ArrayList<Integer> nodes;
        IntHashSet usedNodes;
        ListIterator<Integer> it;
        private int n;

        IteratorImpl() {
            this.n = UnusedNodesSeedGenerator.this.graph.getNodeCount();
            this.nodes = new ArrayList();
            for (int i = 0; i < this.n; ++i) {
                this.nodes.add(i);
            }
            Collections.sort(this.nodes, new Comparator<Integer>(){

                @Override
                public int compare(Integer foo, Integer bar) {
                    int comp = UnusedNodesSeedGenerator.this.graph.getDegree(bar) - UnusedNodesSeedGenerator.this.graph.getDegree(foo);
                    if (comp != 0) {
                        return comp;
                    }
                    return foo - bar;
                }
            });
            this.it = this.nodes.listIterator();
            this.usedNodes = new IntHashSet();
        }

        public double getPercentCompleted() {
            return 100.0 * (double)this.usedNodes.size() / (double)this.n;
        }

        public boolean hasNext() {
            while (this.it.hasNext()) {
                if (this.usedNodes.contains(this.it.next())) continue;
                this.it.previous();
                return true;
            }
            return false;
        }

        public MutableNodeSet next() {
            MutableNodeSet result = new MutableNodeSet(UnusedNodesSeedGenerator.this.graph);
            int seedNode = this.it.next();
            result.add(seedNode);
            this.usedNodes.add(seedNode);
            return result;
        }

        public void processFoundCluster(NodeSet cluster) {
            for (int i : cluster) {
                this.usedNodes.add(i);
            }
        }
    }
}

