/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.correlation;

import uk.ac.rhul.cs.stats.datastructures.PairedData;

public class KendallCorrelation {
    protected PairedData data = null;
    protected Double cachedR = null;

    public KendallCorrelation(PairedData data) {
        this.data = data;
        this.cachedR = null;
    }

    public static double correlationCoeff(PairedData data) {
        return new KendallCorrelation(data).getR();
    }

    public int getN() {
        return this.data.getN();
    }

    public double getR() {
        if (this.cachedR != null) {
            return this.cachedR;
        }
        long num = 0L;
        long n = this.getN();
        double[] x = this.data.getX();
        double[] y = this.data.getY();
        int i = 0;
        while ((long)i < n) {
            int j = i + 1;
            while ((long)j < n) {
                double signX = Math.signum(x[i] - x[j]);
                double signY = Math.signum(y[i] - y[j]);
                num = (long)((double)num + signX * signY);
                ++j;
            }
            ++i;
        }
        this.cachedR = (double)num / (double)n / (double)(n - 1L) * 2.0;
        return this.cachedR;
    }

    public double getTestStatistic() {
        return this.getR();
    }
}

