\name{RepLOptim}

\title{Repeated Local Optimization}

\alias{RepLOptim}

\description{
\sQuote{RepLOptim} Tries to minimize a function calling local optimizers several times from different random starting points. 
}

\usage{RepLOptim(start, parsd, fr, gr=NULL, inphess=NULL, ..., method="nlminb",
	 lower=NULL, upper=NULL, rethess=FALSE, parmstder=FALSE, control=list()) }

\arguments{
	\item{start}{Vector of starting points used in the first call of the local optimizer.}

	\item{parsd}{Vector of standard deviations for the parameter distribution generating starting points for the local optimizer.}

	\item{fr}{The function to be minimized. If method is neither \dQuote{nlminb} or \dQuote{L-BFGS-B}, fr should accept a lbound and an ubound arguments for the parameter bounds, and should enforce these bounds before calling the local optimization routine.}

	\item{gr}{A function to return the gradient for the \dQuote{nlminb}, \dQuote{BFGS}, \dQuote{CG} and {L-BFGS-B} methods.  If it is \sQuote{NULL}, a finite-difference approximation will be used. For the \dQuote{SANN} method it specifies a function to generate a new candidate point.  If it is \sQuote{NULL} a default Gaussian Markov kernel is used.}

	\item{inphess}{A function to return the hessian for the \dQuote{nlminb} method. Must return a square matrix of order \sQuote{length(parmean)} with the different hessian elements in its lower triangle. It is ignored if method component of the control list is not set to its \dQuote{nlminb} default.}

	\item{\dots}{Further arguments to be passed to \sQuote{fr}, \sQuote{gr} and \sQuote{inphess}.} 

	\item{method}{The method to be used. See \sQuote{Details}.} 

	\item{lower}{Vector of parameter lower bounds. Set to \sQuote{-Inf} (no bounds) by default.}

	\item{upper}{Vector of parameter upper bounds. Set to \sQuote{Inf} (no bounds) by default.}

	\item{rethess}{Bolean flag indicating wether a numerically evaluated hessian matrix at the optimum should be computed and returned. Not available for the \dQuote{nlminb} method.}

	\item{parmstder}{Bolean flag indicating wether parameter assymptotic standard errors based on the inverse hessian approximation to the Fisher information matrix should be computed and returned. Only available if hessian is set to TRUE and if a local miminum with a positive-definite hessian was indeed found. This requirement may fail if \sQuote{nrep} and \sQuote{niter} (and maybe \sQuote{neval}) are not large enough, and for non-trivial problems of moderate or high dimensionality may never be satisfied because of numerical difficulties.}

	\item{control}{A list of control parameters. See below for details.} 
} 

\value{
A list with the following components: \cr

\item{par}{The best result found for the parameter vector.}

\item{val}{The best value (minimum) found for the function fr.}

\item{vallist}{A vector with the best values found for each starting point.}

\item{iterations}{Number the iterations performed by the local optimizer in the call that generated the best result.}

\item{vallis}{A vector with the best values found for each starting point.}

\item{counts}{number of times the function fr was evaluated in the call that generated the result returned.}

\item{convergence}{Code with the convergence status returned by the local optimizer.}

\item{message}{Message generated by the local optimizer.}

\item{hessian}{Numerically evaluated hessian of fr at the result returned. Only returned when the parameter hessian is set to TRUE.} 

\item{hessegval}{Eigenvalues of the hessian matrix. Used to confirm if a local minimum was indeed found. Only returned when the parameter hessian is set to TRUE.} 

\item{stderrors}{Assymptotic standard deviations of the parameters based on the observed information matrix. Only returned when the parse parameter is set to true and the hessian is indeed positive definite.}

}

 \details{
\sQuote{RepLOptim} Tries to minimize a function by calling local optimizers several times from different starting points.
The starting point used in the first call the the local optimizer is the value of the argument \sQuote{start}. Subsquent calls
use starting points generated from uniform distributions of independent variates with means equal to the current best
parameter values and standard deviations equal to the values of the argument \sQuote{parsd}.
If parameter bounds are specified and the uniform limits implied by \sQuote{parsd} violate those bounds, these limits are replaced by the corresponding bounds.

The choice of the local optimizer is made by value of the \sQuote{method} argument. This argument can be a function object implementing the optimizer or a string describing an available R method. In the latter case current alternatives are:  
\dQuote{nlminb} (default) for the \sQuote{nlminb} port routine, \dQuote{nlm} for the \sQuote{nlm} function and \dQuote{Nelder-Mead}, \dQuote{L-BFGS-B}, \dQuote{CG}, \dQuote{L-BFGS-B} and \dQuote{SANN} for the corresponding methods of the \sQuote{optim} function.


Arguments for controling the behaviour of the local optimizer can be specified as components of \code{control} list. This list can include any of the following components: 
\describe{
  \item{maxrepet}{Maximum time of repetions of the same minimum objective value, before
RepLOptim is stoped and the current best solution is returned. By default set to 2.} 

  \item{maxnoimprov}{Maximum number of times the local optimizer is called without improvements
in the minimum objective value, before RepLOptim is stoped and the current best solution is returned.
By default set to 50.} 

  \item{maxreplic}{Maximum number of times the local optimizer is called and returns a valid solution
before RepLOptim is stoped and the current best solution is returned. By default set to 250.}

  \item{allrep}{Total maximum number of replications (including those leading to non-valid solutions)
performed. By default equals ten times the value of maxreplic. Ignored when objbnd is set to \sQuote{Inf}.}

  \item{maxiter}{Maximum number of iterations performed in each call to the local optimizer. By default
set to 500 except with the \dQuote{SANN} mehtod, when by default is set to 1500.}

  \item{maxeval}{Maximum number of function evaluations (nlminb method only) performed in each call
to the nlminb optimizer. By defaults set to 1000.}

  \item{RLOtol}{The relative convergence tolerance of the local optimizer.  The local optimizer
stops if it is unable to reduce the value by a factor of \sQuote{RLOtol *(abs(val) + reltol)}
at a step. Ignored when method is set to \dQuote{nlm}. By default set to the square root of the
computer precision, i.e. to \sQuote{sqrt(.Machine$double.eps)}.}

  \item{HesEgtol}{Numerical tolerance used to ensure that the hessian is non-singular. If the last
eigenvalue of the hessian is positive but the ratio between it and the first eigenvalue is below
HesEgtol the hessian is considered to be semi-definite and the parameter assymptotic standard
errors are not computed. By default set to the square root of the computer precision, i.e. to 
\sQuote{sqrt(.Machine$double.eps)}.}

  \item{objbnd}{Upper bound for the objective. Only solutions leading to objective values below
objbnd are considered as valid.}
}
}

\author{A. Pedro Duarte Silva}


