% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_5_2_GO_Plot.R
\name{BioPathways.Plot}
\alias{BioPathways.Plot}
\title{Plot Gene Ontology Analysis Results}
\usage{
BioPathways.Plot(MarvelObject, go.terms, y.label.size = 10)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{go.terms}{Character strings. Names of gene sets to plot. Should match gene sets name in column \code{Term} of \code{MarvelObject$DE$BioPathways}.}

\item{y.label.size}{Numeric value. Size of y-axis tick labels, i.e. gene set names.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to a new slot named \code{$DE$BioPathways.Plot} containing a plot of gene set name on the y-axis, odds ratio on the x-axis, data point color gradient by adjusted p-values, and data point size scaled by number of differentially spliced genes found in each gene set.
}
\description{
\code{BioPathways.Plot} plots selected gene sets returned from gene ontology analysis.
}
\details{
This function plots selected gene sets returned from gene ontology analysis performed previously using \code{BioPathways}
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Specify GO terms to plot
go.terms <- marvel$DE$BioPathways$Table$Term[c(1:10)]

# Run example
marvel <- BioPathways.Plot(MarvelObject=marvel,
                           go.terms=go.terms,
                           y.label.size=10
                           )

# Check output
marvel$DE$BioPathways$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
