% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_2d_mass.R
\name{hr_levels}
\alias{hr_levels}
\alias{hr_levels.default}
\alias{hr_levels.kde_2d}
\title{#' @rdname kde_1d
#' @export
kernelBiweight <- function(x, mean = 0, sd = 1) {
  h <- sqrt(7)*sd
  ifelse((z <- abs(x-mean)) < h, 15/16*(1 - (z/h)^2)^2/h, 0)
}}
\usage{
hr_levels(x, ...)

\method{hr_levels}{default}(x, p = (1:9)/10, ...)

\method{hr_levels}{kde_2d}(x, ...)
}
\arguments{
\item{x}{an object whose \code{z} component represents the KDE}

\item{...}{extra arguments (currently not used)}

\item{p}{a vector of probability levels}
}
\value{
A vector of density levels defining the home range contours
}
\description{
#' @rdname kde_1d
#' @export
kernelCosine <- function(x, mean = 0, sd = 1) {
  h <- sqrt(1/(1-8/pi^2))*sd
  ifelse((z <- abs(x-mean)) < h, pi/4*cos((pi*z)/(2*h))/h, 0)
}
}
\details{
#' @rdname kde_1d
#' @export
kernelEpanechnikov <- function(x, mean = 0, sd = 1) {
  h <- sqrt(5)*sd
  ifelse((z <- abs(x-mean)) < h, 3/4*(1 - (z/h)^2)/h, 0)
}

#' @rdname kde_1d
#' @export
kernelGaussian <- function(x, mean = 0, sd = 1)
  dnorm(x, mean = mean, sd = sd)

#' @rdname kde_1d
#' @export
kernelLogistic <- function(x, mean = 0, sd = 1)
  stats::dlogis(x, mean, sqrt(3)/pi*sd)

#' @rdname kde_1d
#' @export
kernelOptCosine <- function(x, mean = 0, sd = 1) {
  h <- sqrt(1/(1-8/pi^2))*sd
  ifelse((z <- abs(x-mean)) < h, pi/4*cos((pi*z)/(2*h))/h, 0)
}

#' @rdname kde_1d
#' @export
kernelRectangular <- function(x, mean = 0, sd = 1) {
  h <- sqrt(3)*sd
  ifelse(abs(x-mean) < h, 1/(2*h), 0)
}

#' @rdname kde_1d
#' @export
kernelSquaredCosine <- function(x, mean = 0, sd = 1) {
  h <- sqrt(3/(1-6/pi^2))*sd
  ifelse((z <- abs(x-mean)) < h, cos(pi*z/(2*h))^2/h, 0)
}

#' @rdname kde_1d
#' @export
kernelTriangular <- function(x, mean = 0, sd = 1) {
  h <- sqrt(24)*sd/2
  ifelse((z <- abs(x-mean)) < h, (1 - z/h)/h, 0)
}

#' @rdname kde_1d
#' @export
kernelTricube <- function(x, mean = 0, sd = 1) {
  h <- sqrt(243/35)*sd
  ifelse((z <- abs(x - mean)) < h, 70/81*(1 - (z/h)^3)^3/h, 0)
}

#' @rdname kde_1d
#' @export
kernelTriweight <- function(x, mean = 0, sd = 1) {
  h <- sqrt(9)*sd
  ifelse((z <- abs(x-mean)) < h, 35/32*(1 - (z/h)^2)^3/h, 0)
}

#' @rdname kde_1d
#' @export
kernelUniform <- function(x, mean = 0, sd = 1) {
  h <- sqrt(3)*sd
  ifelse(abs(x-mean) < h, 1/(2*h), 0)
}
Home Range levels

For an object representing a 2-dimensional kernel density estimate
find the level(s) defining a central "home range" region, that is,
a region of probability content p for which all density points
within the region are higher than any density point outside the region.
This makes it a region of probability p with smallest area.
}
\examples{
krc <- with(Boston, {
  criminality <- log(crim)
  spaciousness <- sqrt(rm)
  kde_2d(criminality, spaciousness)
})
plot(krc, xlab = expression(italic(Criminality)),
          ylab = expression(italic(Spaciousness)))
home <- hr_levels(krc, p = 0.5)
contour(krc, add = TRUE, levels = home, labels = "50\%")
}
