% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAVE.R
\name{mave}
\alias{mave}
\alias{mave.compute}
\title{Dimension reduction}
\usage{
mave(formula, data, method = "CSOPG", max.dim = 10, subset,
  na.action = na.fail)

mave.compute(x, y, method = "CSOPG", max.dim = 10)
}
\arguments{
\item{formula}{the model used in regression}

\item{data}{the data}

\item{method}{This parameter specify which method will be used in dimension reduction. It provides
five methods, including "csMAVE","csOPG","meanOPG","meanMAVE","KSIR"
by default, method = 'csOPG'
\itemize{
\item 'meanOPG' and 'meanMAVE' estimate dimension reduction space
           for conditional mean
\item 'csMAVE' and 'csOPG' estimate the central dimension reduction
           space
\item 'KSIR' is a kernel version of sliced inverse regression (Li, 1991). It is fast, but
           with poor accuracy.
}}

\item{max.dim}{the maximum dimension of dimension reduction space. The default is 10.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. The default
is na.action, which wil stop calculations. If na.action is set to be na.omit, the incomplete cases
will be removed.}

\item{x}{The design matrix.}

\item{y}{The respond vector.}
}
\value{
dr is a list which contains:
\itemize{
\item dir: dir[[d]] is the central space with d-dimension
        d = 1, 2, ..., p reduced direction of different dimensions
\item y: the value of response
\item max.dim: the largest dimensions of CS or CMS which have been calculated in mave function
\item ky: parameter used for DIM for selection
\item x: the original training data
}
}
\description{
This function provides several methods to estimate the central space or central mean space of y on x.
 It returns the matrix of central space or central mean space for different dimensions and contains
 other information used for dimension selection by \code{\link{mave.dim}}.
}
\examples{
 x <- matrix(rnorm(400*5),400,5)
 b1 <- matrix(c(1,1,0,0,0),5,1)
 b2 <- matrix(c(0,0,1,1,0),5,1)
 eps <- matrix(rnorm(400),400,1)
 y <- x\%*\%b1 + (x\%*\%b2)*eps

 #finding central space based on OPG method
 dr.csopg <- mave.compute(x,y, method = 'csopg')
 #or
 dr.csopg <- mave(y ~ x, method = 'csopg')

 dr.meanopg <- mave.compute(x,y, method = 'meanopg')
 #or
 dr.meanopg <- mave(y ~ x, method = 'meanopg')

 #find central mean space based on ksir method
 dr.ksir <- mave(y~x,method='ksir')
 #or
 dr.ksir <- mave.compute(x,y,method='ksir')

}
\references{
Li K C. Sliced inverse regression for dimension reduction[J]. Journal of the American Statistical Association, 1991, 86(414): 316-327.

Xia Y, Tong H, Li W K, et al. An adaptive estimation of dimension reduction space[J]. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 2002, 64(3): 363-410.

Xia Y. A constructive approach to the estimation of dimension reduction directions[J]. The Annals of Statistics, 2007: 2654-2690.

Wang H, Xia Y. Sliced regression for dimension reduction[J]. Journal of the American Statistical Association, 2008, 103(482): 811-821.
}
\seealso{
\code{\link{mave.dim}} for dimension selection
}

