% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBplotScores.R
\name{MBplotScores}
\alias{MBplotScores}
\title{Customizable plots of scores related information}
\usage{
MBplotScores(
  res,
  axes = c(1, 2),
  block = 0,
  color = NULL,
  select = 1:nrow(res$Scor.g),
  title = NULL,
  size = 2.25
)
}
\arguments{
\item{res}{An object resulting from \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}}.}

\item{axes}{Which dimensions should be plotted?}

\item{block}{Of which block? Block 0 corresponds to global components.}

\item{color}{Either NULL (default) or a character vector of length \emph{select}. Controls the color of each individual plotted. Useful if individuals pertain to different a priori known groups. By default individuals are colored in black for global components and in the block color (the same as in \code{\link{MBplotVars}}) for block components.}

\item{select}{A numeric or integer vector to select which individuals should be plotted. By default, all individuals are plotted.}

\item{title}{An optional title to be added to the plot.}

\item{size}{The overall size of labels, points, etc.}
}
\value{
The required plot.
}
\description{
Plots scores related information of \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}} with several options of customization.
}
\examples{
# Unsupervised example

data(ham)
X=ham$X
block=ham$block
res.mbpca <- MBPCA(X,block, name.block=names(block))
MBplotScores(res.mbpca)

# Supervised example

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block=names(block))
MBplotScores(res.mbpls)

}
\seealso{
\code{\link{plot.MBPCA}} \code{\link{plot.ComDim}} \code{\link{plot.MBPLS}} \code{\link{plot.MBWCov}}
}
