% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMCMCtree.R
\name{plotMCMCtree}
\alias{plotMCMCtree}
\title{Plot distribution from MCMCtree node estimations}
\usage{
plotMCMCtree(parameters, method = c("skewT", "skewNormal", "cauchy",
  "gamma", "bound"), title, upperTime, lowerTime = 0,
  plotMCMCtreeData = TRUE)
}
\arguments{
\item{parameters}{output parameters from node estimation function}

\item{method}{one of skewT, skewNormal, cauchy, gamma, or bound}

\item{title}{title for the plot}

\item{upperTime}{maxmimum age for x-axis plot}

\item{lowerTime}{maxmimum age for x-axis plot (default = 0)}

\item{plotMCMCtreeData}{If TRUE returns co-ordinates to plot distributions to allow greater flexibility (default = TRUE)}
}
\value{
plot of the specified prior applied for a node

If plotMCMCtreeData=TRUE x and y coordinates of distributions from 0 to upperTime on x axis
}
\description{
Estimate the offset and scale paramaters of a soft-tailed cauchy distribution and output trees for MCMCtree input
}
\examples{
data(apeData)
attach(apeData)
monophyleticGroups <- list()
monophyleticGroups[[1]] <- c("human", "chimpanzee",
"bonobo", "gorilla", "sumatran", "orangutan", "gibbon")
monophyleticGroups[[2]] <- c("human", "chimpanzee",
"bonobo", "gorilla")
monophyleticGroups[[3]] <- c("human",
"chimpanzee", "bonobo")
monophyleticGroups[[4]] <- c("sumatran", "orangutan")
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne"=30, "nodeTwo"=12,
"nodeThree"=12, "nodeFour"=20) / 10
cauchy <- estimateCauchy(minAge=minimumTimes[1], maxAge=maximumTimes[1],
monoGroups=monophyleticGroups[[1]], offset=0.5, phy=apeTree, plot=FALSE)
## un-comment to run
plotMCMCtree(parameters=cauchy$parameters, method="cauchy",
title="cauchyPlot", upperTime=maximumTimes[1]+1)
}
