% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareGen.R
\name{prepareGen}
\alias{prepareGen}
\title{Prepare General Data for the MCPMod Function}
\usage{
prepareGen(
  family = c("negative binomial", "binomial", "poisson"),
  link = c("log", "logit", "probit", "cauchit", "cloglog", "identity", "log risk ratio",
    "risk ratio", "sqrt"),
  w = NULL,
  dose,
  resp,
  data = NULL,
  addCovars = ~1,
  placAdj = FALSE,
  offset = NULL,
  ...
)
}
\arguments{
\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string for the model link function.}

\item{w}{Either a numeric vector of the same length as dose and resp, or a
character vector denoting the column name in the data.}

\item{dose, resp}{Either vectors of equal length specifying dose and response
values, or character vectors specifying the names of variables in the data
frame specified in \code{data}.}

\item{data}{Data frame with names specified in `dose`, `resp`, and optionally
`w`. If data is not specified, it is assumed that `dose` and `resp` are
numerical vectors}

\item{addCovars}{Formula specifying additive linear covariates (e.g. `~
factor(gender)`).}

\item{placAdj}{Logical specifying whether the provided by `resp` are to be
treated as placebo-adjusted estimates.}

\item{offset}{Either a numeric vector of the same length as dose and resp, or a
character vector denoting the column name in the data.}

\item{...}{Additional arguments to be passed to \code{glm} or \code{glm.nb}.
This is especially useful when a fitting error is returned. In these cases,
it may be useful to supply a \code{start} vector for the parameters.}
}
\value{
A list containing the \eqn{\mu} vector and \eqn{S} matrix.
}
\description{
This function serves as an alternative for using the MCPModGen function
directly for general data. The function returns the estimates for \eqn{\mu} and
\eqn{S}, which are needed for MCPMod.
}
\examples{
# Analyze the binary migraine data from the DoseFinding package.
data(migraine)
models = Mods(linear = NULL, emax = 1, quadratic = c(-0.004), doses = migraine$dose)

# Now analyze using binomial weights
PFrate <- migraine$painfree/migraine$ntrt
migraine$pfrat = migraine$painfree / migraine$ntrt
muS = prepareGen("binomial", "logit", w = "ntrt", dose = "dose",
                 resp = "pfrat", data = migraine)
## Look at the elements of muS
muS
MCPMod(muS$data$dose, muS$data$resp, models = models, S = muS$S,
       type = "general", selModel = "aveAIC",Delta = 0.2)
}
