% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MarkovChain.R
\name{TransMatrix}
\alias{TransMatrix}
\title{Transition Matrix Estimation}
\usage{
TransMatrix(sequence, order = 1, probs = TRUE)
}
\arguments{
\item{sequence}{A vector of integers representing the sequence. The sequence must be in the form of 1,2,3,...}

\item{order}{Integer from 1 to 5. Order of the Markov chain. By default is set to 1.}

\item{probs}{Logical. If TRUE probability matrices are returned, otherwise count matrices are returned. By default is set to TRUE.}
}
\description{
This function allows you to estimate transition matrices (probabilities or counts) for up-to-fifth-order discrete Markov chains. For n-order Markov chains with n greater than 1, you can access the estimated transition matrices through nested lists.
}
\examples{
seq <- sample(c(1,2,3,4), size = 1000, replace = TRUE)
TransMatrix(seq, order = 1, probs = TRUE)
TransMatrix(seq, order = 2, probs = FALSE)
mc <- TransMatrix(seq, order = 4, probs = TRUE)
mc[[1]][[2]][[3]] # through nested lists you can access to the estimated transition matrices
}
\keyword{chain}
\keyword{markov}
\keyword{matrix}
\keyword{transition}

