% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GendataLDA.R
\name{GendataLDA}
\alias{GendataLDA}
\title{Generate simulation data (Categorial based on linear discriminant analysis model)}
\usage{
GendataLDA(n, p, R = 2, error = "norm")
}
\arguments{
\item{n}{Number of subjects in the dataset to be simulated. It will also equal to the
number of rows in the dataset to be simulated, because it is assumed that each
row represents a different independent and identically distributed subject.}

\item{p}{Number of predictor variables (covariates) in the simulated dataset.
These covariates will be the features screened by model-free procedures.}

\item{R}{A positive integer, number of outcome categories for multinomial (categorical) outcome Y.}

\item{error}{The distribution of error term, you can choose "norm" to generate a normal
distribution of error or you choose "t" to generate a t distribution of error with degree=2.
The default is normal distribution.}
}
\value{
the list of your simulation data
}
\description{
Simulates a dataset that can be used to filter out features for ultrahigh-dimensional discriminant analysis.
The simulation is based on the balanced scenarios in Example 3.1 of Cui et al.(2015).
The simulated dataset has p numerical X-predictors and a categorical Y-response.
}
\examples{
n=100;
p=200;
R=3;
data=GendataLDA(n,p,R)
}
\references{
Cui, H., Li, R., & Zhong, W. (2015). Model-free feature screening for ultrahigh dimensional discriminant analysis. Journal of the American Statistical Association, 110(510), 630-641.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
