% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhqol_utilities.R
\name{mhqol_utilities}
\alias{mhqol_utilities}
\title{Provides the scores of the MHQoL based on the textual input (as described in the manual)}
\usage{
mhqol_utilities(
  dimensions,
  country = "Netherlands",
  ignore_invalid = FALSE,
  ignore_NA = TRUE,
  retain_old_variables = TRUE)
}
\arguments{
\item{dimensions}{A dataframe, character vector, numeric vector, or list containing
the character or numeric dimensions of the MHQoL.
Must contain the following dimensions: SI (Self-Image), IN (INdependence),
MO (MOod), RE (RElationships), DA (Daily Activities), PH (Physical Health), FU (FUture).}

\item{country}{The country for which the utilities should be calculated. For now the only option is "Netherlands".}

\item{ignore_invalid}{If TRUE, the function will ignore missing dimensions and continue processing.
If FALSE, the function will stop and throw an error.}

\item{ignore_NA}{If TRUE, the function will ignore NA values in the input data.
If FALSE, the function will stop and throw an error.}

\item{retain_old_variables}{If TRUE, the function will return the original dimensions along with the new utilities.
If FALSE, the function will only return the new utilities.}
}
\value{
A dataframe containing the new utilities based on the MHQoL manual.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function provides the utilities of the MHQoL based on
textual, as described in the manual, or numeric input of the MHQoL.
}
\examples{
# Example usage of the mhqol_utilities function

# Get the MHQoL utilities based on a character vector and do not retain old values
mhqol_utilities(
  dimensions = c(
    SI = "I think very positively about myself",
    IN = "I am very satisfied with my level of independence",
    MO = "I do not feel anxious, gloomy, or depressed",
    RE = "I am very satisfied with my relationships",
    DA = "I am very satisfied with my daily activities",
    PH = "I have no physical health problems",
    FU = "I am very optimistic about my future"
   ),
   retain_old_variables = FALSE
)

# Get the MHQoL utilities based on a numeric vector and ignore missing dimensions
mhqol_utilities(
  dimensions = c(IN = 2, MO = 1, RE = 0, DA = 3, PH = 2, FU = 1),
  ignore_invalid = TRUE
)
}
\keyword{Dimensions}
\keyword{MHQoL}
\keyword{Utilities}
