\name{MLDS-package}
\alias{MLDS-package}
\alias{MLDS}
\docType{package}
\title{
~~ MLDS ~~ Maximum Likelihood Differerence Scaling
}
\description{
Difference scaling is a method for scaling perceived supra-threshold differences.
The package contains functions that allow the user to design and run a difference scaling experiment and to fit the resulting data by maximum likelihood. 
}
\details{
\tabular{ll}{
Package: \tab MLDS\cr
Type: \tab Package\cr
Version: \tab 0.0.4\cr
Date: \tab 2007-04-16\cr
License: \tab GPL\cr
}
The package provides a function, \code{mlds} for estimating a perceptual scale using the data obtained from one or several difference scaling experiments.  A second function, \code{simu.6pt} permits the interval validity of the scale to be evaluated using a bootstrap method.  Several methods are supplied for accessing and examining the \sQuote{mlds} object generated by estimating the scale.
}
\author{
Kenneth Knoblauch and Laurence T. Maloney \cr

Maintainer: Ken Knoblauch \email{knoblauch@lyon.inserm.fr}
}
\references{
 Maloney, L. T. and Yang, J. N. (2003). Maximum likelihood difference scaling. \emph{Journal of Vision}, \bold{3(8):5}, 573--585, \url{http://journalofvision.org/3/8/5/}, doi:10.1167/3.8.5.
}

\keyword{ package }

\examples{
library(MLDS)
data(kk1)  # data for one subject for 330 trials of the same experiment
plot(mlds(kk1)) # fit and plot the fitted difference scale
}
