% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{summary.fullProcess}
\alias{summary.fullProcess}
\title{Object Summaries}
\usage{
\method{summary}{fullProcess}(object, ...)
}
\arguments{
\item{object}{\code{\link{fullProcess}} object}

\item{...}{Not used.}
}
\description{
Summary of a \code{\link{fullProcess}} object
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- fullProcess(X, y)
summary(res)
}
\seealso{
\link{fullProcess} \link{print.fullProcess}
}
