% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_mean.R
\name{group_mean}
\alias{group_mean}
\title{Computes the group mean of a variable}
\usage{
group_mean(x, grp, lm = FALSE)
}
\arguments{
\item{x}{Variable to compute the mean for (e.g., \code{dataframe$varname}).}

\item{grp}{Cluster/grouping variable (e.g., \code{dataframe$cluster}).}

\item{lm}{Compute reliability (lambda) adjusted means.}
}
\value{
Outputs a vector of group means.
}
\description{
Computes the group means of a variable by a specified cluster/group. Can also be used with factors that have two levels.
}
\examples{
data(mtcars)
#create a group mean aggregated variable
mtcars$mpg.barj <- group_mean(mtcars$mpg, mtcars$cyl)
}
