% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{ZeroOneLoss}
\alias{ZeroOneLoss}
\title{Normalized Zero-One Loss (Classification Error Loss)}
\usage{
ZeroOneLoss(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
Zero-One Loss
}
\description{
Compute the zero-one classification loss.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
pred <- ifelse(logreg$fitted.values<0.5, 0, 1)
ZeroOneLoss(y_true=mtcars$vs, y_pred=pred)
}

