% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_model.R
\name{create_rf_model}
\alias{create_rf_model}
\title{Create a random forest classification model}
\usage{
create_rf_model(
  data,
  dependent = colnames(data)[ncol(data)],
  independent = setdiff(colnames(data), dependent),
  train_validate_split = 0.8,
  shiny = FALSE,
  ...
)
}
\arguments{
\item{data}{A \link[base]{data.frame} containing predictors and the outcome.}

\item{dependent}{Character scalar; the name of the outcome (must be a factor for classification).
Defaults to the last column of \code{data}.}

\item{independent}{Character vector; names of predictor variables.
Defaults to all columns except \code{dependent}.}

\item{train_validate_split}{Numeric in (0, 1); proportion of rows used for training. Default is \code{0.8}.}

\item{shiny}{Logical; if \code{TRUE}, trains incrementally and reports progress via \link{MLmorph} app. Default \code{FALSE}.}

\item{...}{Additional arguments passed to \link[randomForest]{randomForest} (e.g., \code{ntree}).}
}
\value{
A named list with components:
\itemize{
\item \code{model}: a \link[randomForest]{randomForest} return object.
\item \code{variables_importance}: matrix from \link[randomForest]{importance}.
\item \code{model_performance_on_test}: a \link[caret]{confusionMatrix} return object on the validation set.
}
}
\description{
Create a random forest classification model
}
\examples{
n <- 60
y  <- factor(sample(letters[1:3], n, TRUE))
x1 <- factorize_numeric_vector(runif(n, 10, 20), breaks_no = 3)
x2 <- factorize_numeric_vector(runif(n,  1,  2), breaks_no = 5)
df <- data.frame(y, x1, x2)
fit <- create_rf_model(df, dependent = "y", ntree = 50)
names(fit)
}
