% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC2Pro.R
\name{IC2Pro}
\alias{IC2Pro}
\title{Calculate non-parametric estimate for case II interval censored survival function}
\usage{
IC2Pro(L, R, control = IC2Control(), ...)
}
\arguments{
\item{L}{The numeric vector of left endpoints of censoring interval, the first element of Surv when type=’interval2’.}

\item{R}{The numeric vector of right endpoints of censoring interval, the second element of Surv function when type=’interval2’.}

\item{control}{An object as created by \code{IC2Control}}

\item{...}{Additional arguments}
}
\value{
An object of class \code{IC2Pro} that contains the following fields: \code{error}: convergence result; \code{strata}: dimensions of \code{df_tab};
\code{s}: unique ordered elements of \eqn{ {0, L_{i}, R_{i}, Inf} }; \code{S}: the survival function;
\code{df_tab}: the data frame of survival intervals and survival probabilities for each interval.
}
\description{
Calculate non-parametric estimate for case II interval censored survival function
}
\examples{
L <- c(1.4, 1.5, 1.3, 0.9, 0.4, 0.2, 0.5, 0.03, 1.7, 0.2)
R <- c(2.2, 3, 2.4, 1.2, 2.8, 0.3, 1.6, 2.5, 2.6, 3.4)
IC2Pro(L, R, control=IC2Control())

}
\references{
Tian G.L., Huang X.F. and Xu, J.(2019). 'An assembly and decomposition approach for constructing separable minorizing functions in a class of MM algorithms.' \emph{Statistica Sinica} \strong{29}(2), 961-982.
}
\seealso{
\code{\link{IC2Control}}
}
