% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.R
\name{pathway_xvr}
\alias{pathway_xvr}
\title{Plot of residuals against pathway variable}
\usage{
pathway_xvr(full_model, reduced_model, pathway_type)
}
\arguments{
\item{full_model}{Full model including covariate of interest
(= pathway variable)}

\item{reduced_model}{Reduced model excluding covariate of interest}

\item{pathway_type}{Type of pathway values. \code{pathway_wb} are
pathway values proposed by Weller and Barnes. \code{pathway_gvalue}
are values as calculated by Gerring.}
}
\value{
A plot of the chosen type of pathway values against the pathway
variable created with \code{\link{ggplot2}}.
}
\description{
Plot of residuals against pathway variable
}
\examples{
df_full <- lm(mpg ~ disp + wt, data = mtcars)
df_reduced <- lm(mpg ~ wt, data = mtcars)
pathway_xvr(df_full, df_reduced, pathway_type = "pathway_wb")

}
