% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{residstd_plot}
\alias{residstd_plot}
\title{Plot of typical and deviant cases based on residuals' standard deviation}
\usage{
residstd_plot(resid_df)
}
\arguments{
\item{resid_df}{A dataframe created with \code{\link{residstd}}.}
}
\value{
A plot of the observed outcome against the fitted outcome with
interval and case classifications. Created with \code{\link{ggplot2}}.
}
\description{
Plot of typical and deviant cases based on residuals' standard deviation
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
residstd_status <- residstd(df, stdshare = 1)
residstd_plot(residstd_status)

}
