## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
#  library(MOCHA)
#  library(ArchR)

## -----------------------------------------------------------------------------
#  # You should substitute this with your own ArchR project.
#  # You must have completed cell labeling with your ArchR project.
#  
#  myArchRProj <- ArchR::loadArchRProject("/home/jupyter/FullCovid")
#  
#  # Define your annotation package for TxDb object(s)
#  # and genome-wide annotation.
#  # Here our samples are human using hg38 as a reference.
#  # For more info: <https://bioconductor.org/packages/3.15/data/annotation/>
#  
#  library(TxDb.Hsapiens.UCSC.hg38.refGene)
#  library(org.Hs.eg.db)
#  TxDb <- TxDb.Hsapiens.UCSC.hg38.refGene
#  Org <- org.Hs.eg.db
#  
#  # Optional: Filter your ArchR project by sample.
#  # For our example we filter ArchR Project to three samples from
#  # each COVID Status (3 Positive, 3 Negative).
#  
#  samplesToKeep <- c( "B011-AP0C1W3", "B011-AP0C1W8", "B011-AP0C2W1", "B025_FSQAAZ0BZZS-01", "B025_FSQAAZ0C0YJ-01", "B025_FSQAAZ0C00P-07" )
#  idxSample <- BiocGenerics::which(myArchRProj$Sample %in% samplesToKeep)
#  cellsSample <- myArchRProj$cellNames[idxSample]
#  myArchRProj <- myArchRProj[cellsSample, ]

## -----------------------------------------------------------------------------
#  # Parameters for calling open tiles.
#  cellPopLabel <- "CellSubsets"
#  cellPopulations <- c("MAIT", "CD16 Mono", "DC")
#  numCores <- 20

## -----------------------------------------------------------------------------
#  tileResults <- MOCHA::callOpenTiles(
#    myArchRProj,
#    cellPopLabel = cellPopLabel,
#    cellPopulations = cellPopulations,
#    TxDb = TxDb,
#    Org = Org,
#    numCores = numCores
#  )

## -----------------------------------------------------------------------------
#  # We have 6 samples total: 3 samples for each COVID status (3 positive and 3 negative).
#  # Since these groupings may have unique biology and we expect differences
#  # in accessibility, we want to compute consensus tiles on each
#  # group independently and take the union of consensus tiles from each group.
#  groupColumn <- "COVID_status"
#  
#  # We set the threshold to require a tile must be open in at least 2 samples
#  # in its group to be retained (2/3=0.66)
#  threshold <- 0.66
#  
#  # Alternatively, you can set the threshold to 0 to keep the union of
#  # all samples' open tiles.
#  # This is equivalent to setting a threshold that would retain
#  # tiles that are open in at least one sample.
#  
#  SampleTileMatrices <- MOCHA::getSampleTileMatrix(
#    tileResults,
#    cellPopulations = cellPopulations[1],
#    groupColumn = groupColumn,
#    threshold = threshold,
#    log2Intensity = TRUE
#  )

## -----------------------------------------------------------------------------
#  # This function can also take any GRanges object
#  # and add annotations to its metadata.
#  SampleTileMatricesAnnotated <- MOCHA::annotateTiles(SampleTileMatrices)
#  
#  # Load a curated motif set from library(chromVARmotifs)
#  # included with ArchR installation
#  data(human_pwms_v2)
#  SampleTileMatricesAnnotated <- MOCHA::addMotifSet(
#    SampleTileMatricesAnnotated,
#    pwms = human_pwms_v2,
#    w = 7 # weight parameter for motifmatchr
#  )

## -----------------------------------------------------------------------------
#  countSE <- MOCHA::extractRegion(
#    SampleTileObj = SampleTileMatrices,
#    cellPopulations = "CD16 Mono",
#    region = "chr3:38137866-38139912",
#    groupColumn = "COVID_status",
#    numCores = numCores,
#    sampleSpecific = FALSE
#  )
#  dev.off()
#  pdf("ExamplePlot.pdf")
#  # Note that to show specific genes with the option' whichGene'
#  # you must have the package RMariaDB installed
#  MOCHA::plotRegion(countSE = countSE, whichGene = "MYD88")
#  dev.off()

## -----------------------------------------------------------------------------
#  cellPopulation <- "MAIT"
#  foreground <- "Positive"
#  background <- "Negative"
#  
#  # Standard output will display the number of tiles found below a false-discovery rate threshold.
#  # This parameter does not filter results and only affects the afforementioned message.
#  fdrToDisplay <- 0.2
#  
#  # Choose to output a GRanges or data.frame.
#  # Default is TRUE
#  outputGRanges <- TRUE
#  
#  differentials <- MOCHA::getDifferentialAccessibleTiles(
#    SampleTileObj = SampleTileMatrices,
#    cellPopulation = cellPopulation,
#    groupColumn = groupColumn,
#    foreground = foreground,
#    background = background,
#    fdrToDisplay = fdrToDisplay,
#    outputGRanges = outputGRanges,
#    numCores = numCores
#  )

## -----------------------------------------------------------------------------
#  regions <- head(differentials, 10)
#  
#  # Alternatively, define regions as a character vector
#  # of region strings in the format "chr:start-end"
#  # regions <- c(
#  # "chrY:7326500-7326999",
#  # "chrY:7327000-7327499",
#  # "chrY:7339500-7339999",
#  # "chrY:7344500-7344999"
#  # )
#  
#  links <- MOCHA::getCoAccessibleLinks(
#    SampleTileObj = SampleTileMatrices,
#    cellPopulation = cellPopulation,
#    regions = regions,
#    windowSize = 1 * 10^6,
#    numCores = numCores,
#    verbose = TRUE
#  )
#  
#  # Optionally filter these links by their absolute
#  # correlation - this output also adds the chromosome,
#  # start, and end site of each link to the table.
#  
#  MOCHA::filterCoAccessibleLinks(links, threshold = 0.7)

